require( "scripts/style.lua" );


kButtonSpacing = 43;    -- Put our buttons 60 pixels apart
kButtonY = kCenter-105;  -- Three buttons means center 60 pixels above the center

if( PauseGame~=nil)then
    PauseGame();
end

MakeDialog
{
    -- Name the modal dialog
    name = "preload_window",

    Bitmap
    {
        x=kCenter,
        y=kCenter,
        --w= 624,
        --h= 531,
        name = "imgBG",
        image="panels/pad",
        Button
        {
            name = "btnOK",
            font = StandardButtonFont,
            graphics = StButtonGraphicsSm,
            font = MenuButtonFont;
            sound = kDefaultButtonSound,            
            label="play",
            close = true,
            flags = kHAlignCenter + kVAlignCenter,
            command=
                function()
                    -- Pop up an options screen
                    if( ResumeGame ~= nil)then
                        ResumeGame();
                    end
                end;
            x = 380,
            y = 450,
        },
        Bitmap
        { 
            name="preview_image",
            image="",
            x=kCenter,
            y=kCenter,
            w=100,
            h=100,
        };
        
        Text
        {
            name = "txtMessage",
            font = {  standardFont, 22, BlackColor },
            flags = kHAlignCenter + kVAlignCenter,
            x = 115,
            y = 140,
            w = 396,-- - 40,
            h = 232,-- - 40,
        },
        Bitmap
        { 
            name="line_delim_top",
            image="slider/res_orn_top.png",
            x=274,
            y=352;
        };
        Text
        {
            font = {  standardFont, 26, DarkBlueColor },
            name = "goal_description_text",
            x=203,
            y=368,
            w=140,
            h=40,
            label = "goal_preview_text";
        },
        Text
        {
            font = {  standardFont, 26, DarkBlueColor },
            name = "goal_value",
            x=341,
            y=368,
            w=100,
            h=40,
            label = "";
        },
        Text
        {
            font = {  standardFont, 26, DarkRedColor },
            name = "expert_description_text",
            x=203,
            y=398,
            w=140,
            h=40,
            label = "expert_preview_text";
        },
        Text
        {
            font = {  standardFont, 26, DarkRedColor },
            name = "expert_value",
            x=341,
            y=398,
            w=100,
            h=40,
            label = "";
        },
        Text
        {
            font = {  bigButtonFont, 50, DarkBlueColor },
            name = "num_level",
            flags = kHAlignCenter + kVAlignCenter,
            x=160,
            y=12,
            w=302,
            h=72,
            label = "";
        },
        Text
        {
            font = {  bigButtonFont, 40, DarkBlueColor },
            name = "num_level_endl",
            flags = kHAlignCenter + kVAlignCenter,
            x=160,
            y=28,
            w=302,
            h=72,
            label = "";
        },
        Text
        {
            font = {  bigButtonFont, 30, DarkBlueColor },
            name = "diff_level",
            flags = kHAlignCenter + kVAlignCenter,
            x=160,
            y=0,
            w=302,
            h=72,
            label = "";
        },
    },
}

function OnInit()
    --gPreviewWndInfo = {message=aMessage;image=aImage;goal=aGoal;expert=aExpert;};
    if (gPreviewWndInfo == nil) then return; end
    SetLabel("txtMessage",GetString(gPreviewWndInfo.message));
    if (IsBonusLevel(gGlobalPlayerInfo.gLevelNum)) then
        EnableWindow("expert_description_text",false);
        EnableWindow("expert_value",false);
        SetLabel("goal_value",""..gPreviewWndInfo.expert);
    else
        SetLabel("goal_value",""..gPreviewWndInfo.goal);
        if (gGameMode == 0) then
            SetLabel("expert_value",""..gPreviewWndInfo.expert);
        else
            EnableWindow("expert_description_text",false);
            EnableWindow("expert_value",false);
        end
    end
    
    if (gGameMode == 0) then
        EnableWindow("diff_level",false);
        EnableWindow("num_level_endl",false);
        EnableWindow("num_level",true);
        SetLabel("num_level",GetString("num_level_text",""..gGlobalPlayerInfo.gLevelNum));
    else
        EnableWindow("diff_level",true);
        EnableWindow("num_level_endl",true);
        EnableWindow("num_level",false);
        SetLabel("num_level_endl",GetString("map_endless_"..gCurFarm));
        SetLabel("diff_level",GetString("level_endless_diff"..gEndlessDifficulty));
    end
    
    if (gPreviewWndInfo.image ~= "") then
        SetBitmap("preview_image",gPreviewWndInfo.image,1);
    else
        EnableWindow("preview_image",false);
    end
    SetPosition("preview_image",kCenter,kCenter-117);
end

OnInit();

